StringVal="2e-5"
#StringTask="CoLA SST-2 MRPC STS-B QQP QNLI RTE"
model_name="main/electrabxclip/Epoch01_XATTNBERT"
task=SWAG
seeds="995 996 997 998 999"
for seed in $seeds; do
	for val in $StringVal; do 
		echo ${val}
		OutDir="results/finetune/distil_${model_name}/${task}/lr-"
		OutDir+="${val}"
		OutDir+="seed-${seed}"
		mkdir -p "$OutDir"
		echo ${OutDir}
		CUDA_VISIBLE_DEVICES=0 PYTHONPATH=$PYTHONPATH:./src python ./src/finetune/x_run_multiple_choice_distil.py \
		--task_name swag \
		--config_name bert-base-uncased \
		--tokenizer_name bert-base-uncased \
		--model_name_or_path "results/pretrain/${model_name}.pth" \
		--xlayers 2 \
		--do_train \
		--do_eval \
		--do_predict \
		--data_dir data/${task} \
		--learning_rate $val \
		--warmup_ratio 0.1 \
		--num_train_epochs 3 \
		--max_seq_length 128 \
		--output_dir $OutDir \
		--per_device_eval_batch_size=16 \
		--per_device_train_batch_size=16 \
		--gradient_accumulation_steps 2 \
		--overwrite_output \
		--overwrite_cache \
		--evaluation_strategy epoch \
		--seed ${seed} \
		--save_total_limit 1\ |& tee "results/finetune/distil_${model_name}/${task}/${task}_lr${val}_seed${seed}.txt" -i
		#--eval_steps 12 \
		#--logging_steps 12 \
		#--config_name "bert-base-cased" \
		#--tokenizer_name "bert-base-cased" \
		#--evaluate_during_training
		
		#unc-nlp/
	done
done
